/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MRfQLine;
import org.compiere.model.MRfQLineQty;
import org.compiere.model.MRfQResponse;
import org.compiere.model.X_C_RfQ;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.TimeUtil;
import org.compiere.util.Util;

public class MRfQ
extends X_C_RfQ {
    private static final long serialVersionUID = 5332116213254863257L;

    public static MRfQ get(int C_RfQ_ID) {
        return MRfQ.get(C_RfQ_ID, null);
    }

    public static MRfQ get(int C_RfQ_ID, String trxName) {
        return MRfQ.get(Env.getCtx(), C_RfQ_ID, trxName);
    }

    public static MRfQ get(Properties ctx, int C_RfQ_ID, String trxName) {
        MRfQ retValue = new MRfQ(ctx, C_RfQ_ID, trxName);
        if (retValue.get_ID() == C_RfQ_ID) {
            return retValue;
        }
        return null;
    }

    public MRfQ(Properties ctx, String C_RfQ_UU, String trxName) {
        super(ctx, C_RfQ_UU, trxName);
        if (Util.isEmpty(C_RfQ_UU)) {
            this.setInitialDefaults();
        }
    }

    public MRfQ(Properties ctx, int C_RfQ_ID, String trxName) {
        super(ctx, C_RfQ_ID, trxName);
        if (C_RfQ_ID == 0) {
            this.setInitialDefaults();
        }
    }

    private void setInitialDefaults() {
        this.setDateResponse(new Timestamp(System.currentTimeMillis()));
        this.setDateWorkStart(new Timestamp(System.currentTimeMillis()));
        this.setIsInvitedVendorsOnly(false);
        this.setQuoteType("S");
        this.setIsQuoteAllQty(false);
        this.setIsQuoteTotalAmt(false);
        this.setIsRfQResponseAccepted(true);
        this.setIsSelfService(true);
        this.setProcessed(false);
    }

    public MRfQ(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MRfQ(MRfQ copy) {
        this(Env.getCtx(), copy);
    }

    public MRfQ(Properties ctx, MRfQ copy) {
        this(ctx, copy, null);
    }

    public MRfQ(Properties ctx, MRfQ copy, String trxName) {
        this(ctx, 0, trxName);
        this.copyPO(copy);
    }

    public MRfQLine[] getLines() {
        ArrayList<MRfQLine> list;
        block6: {
            list = new ArrayList<MRfQLine>();
            String sql = "SELECT * FROM C_RfQLine WHERE C_RfQ_ID=? AND IsActive='Y' ORDER BY Line,C_RfQLine_ID ";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql, this.get_TrxName());
                    pstmt.setInt(1, this.getC_RfQ_ID());
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        list.add(new MRfQLine(this.getCtx(), rs, this.get_TrxName()));
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, sql, e);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block6;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        MRfQLine[] retValue = new MRfQLine[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public MRfQResponse[] getResponses(boolean activeOnly, boolean completedOnly) {
        ArrayList<MRfQResponse> list;
        block8: {
            list = new ArrayList<MRfQResponse>();
            Object sql = "SELECT * FROM C_RfQResponse WHERE C_RfQ_ID=?";
            if (activeOnly) {
                sql = (String)sql + " AND IsActive='Y'";
            }
            if (completedOnly) {
                sql = (String)sql + " AND IsComplete='Y'";
            }
            sql = (String)sql + " ORDER BY Price";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql, this.get_TrxName());
                    pstmt.setInt(1, this.getC_RfQ_ID());
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        list.add(new MRfQResponse(this.getCtx(), rs, this.get_TrxName()));
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, (String)sql, e);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block8;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        MRfQResponse[] retValue = new MRfQResponse[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("MRfQ[");
        sb.append(this.get_ID()).append(",Name=").append(this.getName()).append(",QuoteType=").append(this.getQuoteType()).append("]");
        return sb.toString();
    }

    public boolean isQuoteTotalAmtOnly() {
        return "T".equals(this.getQuoteType());
    }

    public boolean isQuoteSelectedLines() {
        return "S".equals(this.getQuoteType());
    }

    public boolean isQuoteAllLines() {
        return "A".equals(this.getQuoteType());
    }

    public String checkQuoteTotalAmtOnly() {
        if (!this.isQuoteTotalAmtOnly()) {
            return null;
        }
        MRfQLine[] lines = this.getLines();
        int i = 0;
        while (i < lines.length) {
            MRfQLine line = lines[i];
            MRfQLineQty[] qtys = line.getQtys();
            if (qtys.length > 1) {
                this.log.warning("isQuoteTotalAmtOnlyValid - #" + qtys.length + " - " + String.valueOf(line));
                String msg = "@Line@ " + line.getLine() + ": #@C_RfQLineQty@=" + qtys.length + " - @IsQuoteTotalAmt@";
                return msg;
            }
            ++i;
        }
        return null;
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        if (this.getDateWorkStart() != null && this.getDeliveryDays() != 0) {
            this.setDateWorkComplete(TimeUtil.addDays(this.getDateWorkStart(), this.getDeliveryDays()));
        } else if (this.getDateWorkStart() != null && this.getDeliveryDays() == 0 && this.getDateWorkComplete() != null) {
            this.setDeliveryDays(TimeUtil.getDaysBetween(this.getDateWorkStart(), this.getDateWorkComplete()));
        } else if (this.getDateWorkStart() == null && this.getDeliveryDays() != 0 && this.getDateWorkComplete() != null) {
            this.setDateWorkStart(TimeUtil.addDays(this.getDateWorkComplete(), this.getDeliveryDays() * -1));
        }
        return true;
    }
}

